package com.example.myapplication

import android.util.Log
import android.widget.ImageButton

class Squares(imagebutton: Array<Array<ImageButton>>) {
    var square = arrayOf(
        arrayOf(Square(0,imagebutton[0][0]), Square(0,imagebutton[0][1]), Square(0,imagebutton[0][2])),
        arrayOf(Square(0,imagebutton[1][0]), Square(0,imagebutton[1][1]), Square(0,imagebutton[1][2])),
        arrayOf(Square(0,imagebutton[2][0]), Square(0,imagebutton[2][1]), Square(0,imagebutton[2][2]))
    )
    var houkou = arrayOf(
        arrayOf(-1,-1), arrayOf(-1,0), arrayOf(-1,1),
        arrayOf(0,-1), arrayOf(0,1),
        arrayOf(1,-1), arrayOf(1,0), arrayOf(1,1)
    )
    fun isKUHAKU(x:Int,y:Int):Boolean{
        return if(square[x][y].state == Const.KUHAKU) true else false
    }
    fun click(x:Int,y:Int,next:Boolean) {
        var ne= if(next) Const.BATU else Const.MARU
        square[x][y].click(ne)
    }
    fun jug():Int{  //戻り値 0:勝負つかず、1:✕勝利、2:〇勝利、3:マス目が埋まっている
        var isFinal = true                          //マス目が全て埋まっているかフラグ
        for(idx1 in square.indices){
            for(idx2 in square[idx1].indices){
                if( square[idx1][idx2].state == Const.KUHAKU ){//マス目が空白なら探索しない
                    isFinal=false                       //空白があるのでフラグOFF
                    break;
                }
                var ret = eightCheck(idx1,idx2)     //八方チェック関数を呼び出す
                if(ret != Const.KUHAKU){           //0:勝負つかず以外なら試合終了
                    return ret
                }
            }
        }
        if(isFinal){                                 //マス目が全て埋まっているなら
            return Const.DRAW
        }else {
            return Const.KUHAKU
        }
    }

    fun eightCheck(idx1:Int,idx2:Int):Int{          //戻り値 0:勝負つかず、1:✕勝利、2:〇勝利

        for(h in houkou.indices){                   //八方を探索
            var count = 1
            var x= idx1
            var y= idx2
            while(true){                            //マス目をはみ出すまで永久ループ
                x =  x + houkou[h][0]               //x,y座標を増減し探索
                y = y + houkou[h][1]                //
                if(x >= Const.BAN_SU || x < 0){                //横軸はみ出ている？
                    break
                }
                if(y >= Const.BAN_SU || y < 0){                //縦軸はみ出ている？
                    break
                }
                if(square[idx1][idx2].state == square[x][y].state){//基準と同じマークならcountアップ
                    count++
                }
            }
            if(count >= 3){                         //マークが3つ以上並んだか？
                return square[idx1][idx2].state
            }
        }
        return Const.KUHAKU
    }
    fun allClear() {
        for (idx1 in square.indices) {
            for (idx2 in square[idx1].indices) {
                square[idx1][idx2].click(Const.KUHAKU)
            }
        }
    }
}